<div class="d-flex justify-content-between align-items-center mb-3">
    <h3 class="fw-bold m-0">Rekap Absensi Bulanan</h3>
    <a href="?page=absensi" class="btn btn-outline-secondary btn-sm">
        <i class="bi bi-arrow-left"></i> Kembali ke Input
    </a>
</div>

<div class="card border-0 shadow-sm mb-4">
    <div class="card-body">
        <!-- FILTER KELAS & BULAN -->
        <form method="GET" action="dashboard.php">
            <input type="hidden" name="page" value="absensi_rekap">
            <div class="row g-2">
                <div class="col-md-3">
                    <label class="fw-bold small">Kelas</label>
                    <select name="kelas" class="form-select" required>
                        <option value="">- Pilih -</option>
                        <option value="X-A" <?= (isset($_GET['kelas']) && $_GET['kelas']=='X-A')?'selected':''; ?>>X-A</option>
                        <option value="X-B" <?= (isset($_GET['kelas']) && $_GET['kelas']=='X-B')?'selected':''; ?>>X-B</option>
                        <option value="XI-IPA" <?= (isset($_GET['kelas']) && $_GET['kelas']=='XI-IPA')?'selected':''; ?>>XI-IPA</option>
                        <option value="XI-IPS" <?= (isset($_GET['kelas']) && $_GET['kelas']=='XI-IPS')?'selected':''; ?>>XI-IPS</option>
                        <option value="XII-IPA" <?= (isset($_GET['kelas']) && $_GET['kelas']=='XII-IPA')?'selected':''; ?>>XII-IPA</option>
                        <option value="XII-IPS" <?= (isset($_GET['kelas']) && $_GET['kelas']=='XII-IPS')?'selected':''; ?>>XII-IPS</option>
                        <!-- Tambahkan kelas lain sesuai kebutuhan -->
                    </select>
                </div>
                <div class="col-md-3">
                    <label class="fw-bold small">Bulan</label>
                    <select name="bulan" class="form-select" required>
                        <?php
                        $bln_pilih = isset($_GET['bulan']) ? $_GET['bulan'] : date('m');
                        $nama_bln = [1=>'Januari','Februari','Maret','April','Mei','Juni','Juli','Agustus','September','Oktober','November','Desember'];
                        foreach($nama_bln as $k => $v){
                            $sel = ($k == $bln_pilih) ? 'selected' : '';
                            echo "<option value='$k' $sel>$v</option>";
                        }
                        ?>
                    </select>
                </div>
                <div class="col-md-3">
                    <label class="fw-bold small">Tahun</label>
                    <input type="number" name="tahun" class="form-control" value="<?= isset($_GET['tahun']) ? $_GET['tahun'] : date('Y'); ?>" required>
                </div>
                <div class="col-md-3 d-flex align-items-end">
                    <button type="submit" class="btn btn-primary w-100 fw-bold">Tampilkan Rekap</button>
                </div>
            </div>
        </form>
    </div>
</div>

<?php
if (isset($_GET['kelas'])) {
    $kelas = $_GET['kelas'];
    $bulan = $_GET['bulan'];
    $tahun = $_GET['tahun'];
    
    // Hitung jumlah hari dalam bulan tersebut (28/30/31)
    $jml_hari = cal_days_in_month(CAL_GREGORIAN, $bulan, $tahun);
?>

<div class="card border-0 shadow-sm">
    <div class="card-header bg-white d-flex justify-content-between">
        <h6 class="m-0 fw-bold">Rekap Kelas <?= $kelas ?> - Periode <?= $nama_bln[$bulan] ?> <?= $tahun ?></h6>
        <button onclick="window.print()" class="btn btn-sm btn-secondary"><i class="bi bi-printer"></i> Cetak</button>
    </div>
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-bordered table-sm text-center mb-0" style="font-size: 12px;">
                <thead class="table-light">
                    <tr>
                        <th rowspan="2" class="align-middle">No</th>
                        <th rowspan="2" class="align-middle text-start" style="min-width: 150px;">Nama Siswa</th>
                        <th colspan="<?= $jml_hari ?>">Tanggal</th>
                        <th colspan="4">Total</th>
                    </tr>
                    <tr>
                        <?php for($h=1; $h<=$jml_hari; $h++) { echo "<th>$h</th>"; } ?>
                        <th class="bg-success text-white">H</th>
                        <th class="bg-primary text-white">I</th>
                        <th class="bg-warning text-dark">S</th>
                        <th class="bg-danger text-white">A</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $no = 1;
                    // 1. Ambil Siswa
                    $q_siswa = mysqli_query($koneksi, "SELECT * FROM siswa WHERE kelas='$kelas' ORDER BY nama ASC");
                    
                    while($s = mysqli_fetch_array($q_siswa)){
                        // 2. Ambil Data Absen siswa ini dalam bulan terpilih
                        $id_siswa = $s['id'];
                        $q_absen = mysqli_query($koneksi, "SELECT day(tanggal) as hari, keterangan FROM absensi WHERE id_siswa='$id_siswa' AND month(tanggal)='$bulan' AND year(tanggal)='$tahun'");
                        
                        // Masukkan ke array biar gampang dipanggil
                        $data_absen = [];
                        while($a = mysqli_fetch_array($q_absen)){
                            $data_absen[$a['hari']] = $a['keterangan'];
                        }

                        // Hitung Total
                        $h=0; $i=0; $skt=0; $a=0;
                    ?>
                    <tr>
                        <td><?= $no++ ?></td>
                        <td class="text-start fw-bold"><?= $s['nama'] ?></td>
                        
                        <!-- Loop Tanggal 1 s.d Akhir Bulan -->
                        <?php for($tgl=1; $tgl<=$jml_hari; $tgl++) { 
                            $ket = isset($data_absen[$tgl]) ? $data_absen[$tgl] : '-';
                            
                            // Warna sel
                            $bg = '';
                            if($ket=='H') { $bg='bg-success text-white'; $h++; $ket='•'; } // Pakai titik biar rapi
                            elseif($ket=='I') { $bg='bg-primary text-white'; $i++; }
                            elseif($ket=='S') { $bg='bg-warning text-dark'; $skt++; }
                            elseif($ket=='A') { $bg='bg-danger text-white'; $a++; }
                            
                            echo "<td class='$bg' width='25'>$ket</td>";
                        } ?>

                        <!-- Kolom Total -->
                        <td class="fw-bold"><?= $h ?></td>
                        <td class="fw-bold"><?= $i ?></td>
                        <td class="fw-bold"><?= $skt ?></td>
                        <td class="fw-bold"><?= $a ?></td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php } ?>